/***************************************************************************
**
**  This file is part of QGpGuiStat.
**
**  QGpGuiStat is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  QGpGuiStat is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2005-10-27
**  Copyright: 2005-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef SAMPLECLASSIFICATION_H
#define SAMPLECLASSIFICATION_H

#include <QGpGuiMath.h>
#include <QGpCoreStat.h>

#include "QGpGuiStatDLLExport.h"

namespace Ui {
  class SampleClassification;
}

namespace QGpGuiStat {

  class QGPGUISTAT_EXPORT SampleClassification : public Dialog
  {
    Q_OBJECT
  public:
    SampleClassification(QWidget *parent=nullptr, Qt::WindowFlags f=Qt::Widget);

    void setCurveList(const QList<CurvePropertiesWidget *>& list);
    void setCategories(const Legend * cat);

    void updateAllFields();

    static bool run(CurveBrowser * curves, const Legend * categories, Histogram2D * hist);
  private slots:
    void enableValueConditionWidgets();
    void on_categorizeAction_toggled(bool checked);
    void on_curve1Name_activated(int);
    void on_curve2Name_activated(int);
  private:
    static void setUnchecked(QRadioButton * activeBut, QRadioButton * uncheckBut);

    Ui::SampleClassification * _ui;
  };

} // namespace QGpGuiStat

#endif // SAMPLECLASSIFICATION_H
