/***************************************************************************
**
**  This file is part of QGpGuiStat.
**
**  QGpGuiStat is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  QGpGuiStat is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2022-11-24
**  Copyright: 2022
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "CategoryChooser.h"
#include "ui_CategoryChooser.h"

namespace QGpGuiStat {

  /*!
    \class CategoryChooser CategoryChooser.h
    \brief Brief description of class still missing

    Full description of class still missing
  */

  /*!
    Description of constructor still missing
  */
  CategoryChooser::CategoryChooser(QWidget * parent)
    : QWidget(parent),
      _ui(new Ui::CategoryChooser)
  {
    TRACE;
    _ui->setupUi(this);

    connect(_ui->allCategories, SIGNAL(toggled(bool)), this, SLOT(enableCategoryWidget()));
    connect(_ui->oneCategory, SIGNAL(toggled(bool)), this, SLOT(enableCategoryWidget()));
    connect(_ui->allExceptOneCategory, SIGNAL(toggled(bool)), this, SLOT(enableCategoryWidget()));
  }

  /*!
    Description of destructor still missing
  */
  CategoryChooser::~CategoryChooser()
  {
    TRACE;
    delete _ui;
  }

  void CategoryChooser::updateAllFields()
  {
    enableCategoryWidget();
  }

  void CategoryChooser::setCategories(const Legend& cat)
  {
    for(int i=0; i<cat.count(); i++) {
      _ui->categories->addItem(cat.text(i));
    }
  }

  void CategoryChooser::enableCategoryWidget()
  {
    TRACE;
    _ui->categories->setEnabled(!_ui->allCategories->isChecked());
  }

  SampleClassificationParameters::CategoryCondition CategoryChooser::type() const
  {
    if(_ui->oneCategory->isChecked()) {
      return SampleClassificationParameters::OneCategory;
    } else if(_ui->allExceptOneCategory->isChecked()) {
      return SampleClassificationParameters::AllExceptOneCategory;
    }
    return SampleClassificationParameters::AllCategories;
  }

  int CategoryChooser::category() const
  {
    return _ui->categories->currentIndex();
  }

} // namespace QGpGuiStat

