/***************************************************************************
**
**  This file is part of QGpGuiMath.
**
**  QGpGuiMath is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  QGpGuiMath is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2021-05-25
**  Copyright: 2021
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef IMAGESCALINGPOINTMODEL_H
#define IMAGESCALINGPOINTMODEL_H

#include "QGpGuiMathDLLExport.h"
#include "ImageLayer.h"

namespace QGpGuiMath {

  class QGPGUIMATH_EXPORT ImageScalingPointModel : public QAbstractTableModel
  {
  public:
    ImageScalingPointModel(QObject * parent=nullptr);
    ~ImageScalingPointModel();

    void setReferenceList(QList<ImageLayer::ReferencePoint> * ref);

    int rowCount(const QModelIndex& parent) const;
    int columnCount(const QModelIndex& parent) const;
    QVariant data(const QModelIndex& index, int role) const;
    QVariant headerData(int section, Qt::Orientation orientation, int rol) const;
    bool setData(const QModelIndex& index, const QVariant& value, int role);
    Qt::ItemFlags flags(const QModelIndex&) const;

    void add(const QPoint& p);
    void remove(int index);
    void setReal(int index, const Point2D& p);
  private:
    QList<ImageLayer::ReferencePoint> * _references;
  };

} // namespace QGpGuiMath

#endif // IMAGESCALINGPOINTMODEL_H

