/***************************************************************************
**
**  This file is part of QGpGuiMath.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2011-03-11
**  Copyright: 2011-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include <QGpGuiTools.h>

#include "GeographicalReference.h"

namespace QGpGuiMath {

  /*!
    \class GeographicalReference GeographicalReference.h
    \brief Brief description of class still missing

    Full description of class still missing
  */

  /*!
    Description of constructor still missing
  */
  GeographicalReference::GeographicalReference(QWidget * parent)
    : QWidget(parent)
  {
    TRACE;
    setupUi(this);

    refName->addItem(QString());
    QSettings& reg=CoreApplication::instance()->settings();
    reg.beginGroup("GeographicalReferences");
    QStringList list=reg.childKeys();
    std::sort(list.begin(), list.end());
    NamedPoint p;
    for(QStringList::iterator it=list.begin(); it!=list.end(); it++) {
      if(p.fromString(reg.value(*it).toString())) {
        p.setName(*it);
        _references.append(p);
        refName->addItem(p.name());
      }
    }
  }

  /*!
    Description of destructor still missing
  */
  GeographicalReference::~GeographicalReference()
  {
    TRACE;
  }

  Point2D GeographicalReference::reference() const
  {
    Point2D p;
    p.setX(refLongitude->text().toDouble());
    p.setY(refLatitude->text().toDouble());
    return p;
  }

  void GeographicalReference::save()
  {
    if(!refName->currentText().isEmpty()) {
      Point2D p=reference();
      QSettings& reg=CoreApplication::instance()->settings();
      reg.beginGroup("GeographicalReferences");
      reg.setValue(refName->currentText(), p.toString('g', 20));
    }
  }

  void GeographicalReference::setReference(const Point2D& p)
  {
    refLongitude->setText(QString::number(p.x(), 'f', 10));
    refLatitude->setText(QString::number(p.y(), 'f', 10));
  }

  void GeographicalReference::on_refName_currentIndexChanged(int index)
  {
    if(index>0) {
      setReference(_references.at(index-1));
    }
  }

} // namespace QGpGuiMath
