/***************************************************************************
**
**  This file is part of QGpCoreWave.
**
**  QGpCoreWave is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  QGpCoreWave is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2023-09-29
**  Copyright: 2023
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef OMNIDIRECTIONALARRAYRESPONSE_H
#define OMNIDIRECTIONALARRAYRESPONSE_H

#include <QGpCoreMath.h>

#include "QGpCoreWaveDLLExport.h"

namespace QGpCoreWave {

  class QGPCOREWAVE_EXPORT OmnidirectionalArrayResponse : public AbstractFunction
  {
  public:
    OmnidirectionalArrayResponse(const VectorList<Point2D>& stations);

    void setWavenumber(double k);

    double value(Vector<double>& k) const;
    const VectorList<Point2D>& stations() const {return _stations;}
  private:
    VectorList<Point2D> _stations;
    double _wavenumber;
    double _fac;
    ComplexMatrix _crossSpectrum;
  };

} // namespace QGpCoreWave

#endif // OMNIDIRECTIONALARRAYRESPONSE_H

