/***************************************************************************
**
**  This file is part of QGpCoreWave.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2008-10-17
**  Copyright: 2008-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include "LoveFunction.h"

namespace QGpCoreWave {

/*!
  \class LoveFunction LoveFunction.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

/*!
  Description of constructor still missing
*/
LoveFunction::LoveFunction()
    : AbstractFunction()
{
  TRACE;
  _model=nullptr;
  _love=nullptr;
}

/*!
  Description of destructor still missing
*/
LoveFunction::~LoveFunction()
{
  TRACE;
  delete _love;
}

void LoveFunction::setModel(const Seismic1DModel * m)
{
  TRACE;
  _model=m;
  _love=new Love(m);
}

/*!
  \a x[0] is frequency in Hz, \a x[1] is the slowness.
*/
double LoveFunction::value(Vector<double>& x) const
{
  TRACE;
  _love->setOmega(2.0*M_PI*x[0]);
  return fabs(_love->y(x[1])/(x[0]*x[0]));
}

} // namespace QGpCoreWave
