/***************************************************************************
**
**  This file is part of QGpCoreTools.
**
**  QGpCoreTools is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  QGpCoreTools is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2021-06-29
**  Copyright: 2021
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef OPTION_H
#define OPTION_H

#include "QGpCoreToolsDLLExport.h"

namespace QGpCoreTools {

  template <class T>
  class QGPCORETOOLS_EXPORT Option
  {
  public:
    Option(T v) {_set=false; _value=v;}

    void operator=(const Option<T>& o)=delete;

    void setValue(const T& v) {_set=true; _value=v;}

    bool isSet() const {return _set;}
    const T& value() const {return _value;}
  private:
    T _value;
    bool _set;
  };

} // namespace QGpCoreTools

#endif // OPTION_H

