/***************************************************************************
**
**  This file is part of QGpCoreStat.
**
**  QGpCoreStat is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  QGpCoreStat is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2018-02-22
**  Copyright: 2018-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef SAMPLEFILTER_H
#define SAMPLEFILTER_H

#include "Histogram2D.h"

namespace QGpCoreStat {

  class QGPCORESTAT_EXPORT SampleFilter
  {
  public:
    SampleFilter();
    ~SampleFilter();

    class QGPCORESTAT_EXPORT Sample : public Histogram2D::Sample
    {
    public:
      inline Sample();

      void operator=(const Histogram2D::Sample& s) {Histogram2D::Sample::operator=(s);}

      bool read(const QString& line, int xColumn, int yColumn,
                int verticalNoiseColumn, int horizontalNoiseColumn,
                int powerColumn, int ringColumn,
                int validColumn);

     double time() const {return _time;}
     double frequency() const {return _frequency;}
     double verticalNoise() const {return _verticalNoise;}
     double horizontalNoise() const {return _horizontalNoise;}
     double power() const {return _power;}
     int ring() const {return _ring;}
    private:
      double _time;
      double _frequency;
      double _verticalNoise;
      double _horizontalNoise;
      double _power;
      int _ring;
    };

    void append(const Sample& s) {_samples.append(s);}
    int count() const {return _samples.count();}
    int countValidSamples() const;

    void filterPower(double relThreshold);
    void filterNoise(double threshold);
    void filterXMinimum(double threshold);
    void filterXMaximum(double threshold);
    void filterYMinimum(double threshold);
    void filterYMaximum(double threshold);
    void filterRing(int ring);

    static void showStatistics(int remaining, int original);


    VectorList<Histogram2D::Sample> samples() const;
    typedef VectorList<Sample>::iterator iterator;
    iterator begin() {return _samples.begin();}
    iterator end() {return _samples.end();}
  private:
    void selectPower(int beginIndex, int endIndex, double minPower);
    static bool lessThan(const Sample& s1, const Sample& s2);
    VectorList<Sample> _samples;
  };

  inline SampleFilter::Sample::Sample()
    : Histogram2D::Sample()
  {
    _time=0.0;
    _frequency=0.0;
    _verticalNoise=0.0;
    _horizontalNoise=0.0;
    _power=0.0;
    _ring=0;
  }

} // namespace QGpCoreStat

#endif // SAMPLEFILTER_H

