/***************************************************************************
**
**  This file is part of QGpCoreStat.
**
**  QGpCoreStat is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  QGpCoreStat is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2017-06-11
**  Copyright: 2017-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef HISTOGRAMINVERSION_H
#define HISTOGRAMINVERSION_H

#include <QGpCoreMath.h>
#include <DinverCore.h>

#include "Histogram2D.h"
#include "GaussianMixtureDistribution.h"
#include "GaussianMixtureParameters.h"
#include "MultivariateHistogram.h"
#include "QGpCoreStatDLLExport.h"

namespace QGpCoreStat {

  class QGPCORESTAT_EXPORT HistogramInversion : public QObject
  {
    Q_OBJECT
  public:
    HistogramInversion(int histogramCount, QObject * parent=nullptr);
    ~HistogramInversion();

    void setParameters(const GaussianMixtureParameters& p) {_parameters=p;}
    const GaussianMixtureParameters& parameters() const {return _parameters;}

    void setHistogram(int index, const Histogram2D * h);
    bool checkHistograms() const;
    void start();
    void start(int index);
    void wait();

    const Histogram2D * histogram(int index) const {return _histograms[index];}
    const GaussianMixtureDistribution& distribution(int index) const {return _distributions[index];}
    SetIndex bestMisfitIndex() const {return _na->bestModelIndex();}
    double bestMisfit() const {return _na->misfit(bestMisfitIndex());}
    int modelCount() const {return _na->allModels()->size();}

    QString humanSolution(int index, const QString& prefix);
  signals:
    void histogramFinished(int index);
    void finished();
  private slots:
    void monteCarloFinished();
    void neighborhoodFinished();
  private:
    void internalStart();

    GaussianMixtureParameters _parameters;
    int _histogramCount;
    const Histogram2D ** _histograms;
    MultivariateHistogram * _histogram;

    int _currentIndex;
    int _stopIndex;

    ModelRepository * _na;
    GaussianMixtureDistribution * _distributions;
  };

} // namespace QGpCoreStat

#endif // HISTOGRAMINVERSION_H

