/***************************************************************************
**
**  This file is part of QGpCoreMath.
**
**  QGpCoreMath is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  QGpCoreMath is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2011-11-18
**  Copyright: 2011-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef WINDOWFUNCTIONPARAMETERS_H
#define WINDOWFUNCTIONPARAMETERS_H

#include <QGpCoreTools.h>

#include "QGpCoreMathDLLExport.h"

namespace QGpCoreMath {

  class QGPCOREMATH_EXPORT WindowFunctionParameters: public AbstractParameters
  {
  public:
    WindowFunctionParameters();

    AbstractParameters * clone() const {return new WindowFunctionParameters(*this);}

    enum Shape {Rectangular, Bartlett, Triangular, Parzen, Welch,
                Cosine, Hann, Hamming, Blackman, Nuttall, BlackmanNuttall,
                BlackmanHarris, FlatTop,
                Gaussian, Tukey, BartlettHann,
                Lanczos, KonnoOhmachi};

    ENUM_AS_STRING_DECL(Shape)

    Shape shape() const {return _shape;}
    void setShape(Shape s) {_shape=s;}

    bool reversed() const {return _reversed;}
    void setReversed(bool r) {_reversed=r;}

    double alpha() const {return _alpha;}
    void setAlpha(double a) {_alpha=a;}

    double sigma() const {return _sigma;}
    void setSigma(double s) {_sigma=s;}

    QString toShortString() const;
    void fromShortString(QString s);

    QString toString(PARAMETERS_TOSTRING_ARGS_DECL) const;
    void collectKeywords(PARAMETERS_COLLECTKEYWORDS_ARGS);
  protected:
    int keywordCount(PARAMETERS_KEYWORDCOUNT_ARGS) const;
    bool setValue(PARAMETERS_SETVALUE_ARGS);
  private:
    Shape _shape;
    bool _reversed;
    union {
      double _alpha;
      double _sigma;
    };
  };

} // namespace QGpCoreMath

#endif // WINDOWFUNCTIONPARAMETERS_H
