/***************************************************************************
**
**  This file is part of QGpCoreMath.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2016-08-30
**  Copyright: 2016-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef UTMZONE_H
#define UTMZONE_H

#include <QtCore>

#include "QGpCoreMathDLLExport.h"

namespace QGpCoreMath {

  class Point2D;

  class QGPCOREMATH_EXPORT UtmZone
  {
  public:
    inline UtmZone();
    UtmZone(const Point2D& longLat);

    inline bool operator==(const UtmZone& o) const;
    inline bool operator!=(const UtmZone& o) const;

    bool isValid() const {return _x>-1;}
    bool isValid(const Point2D& p, double tolerance=10000.0) const;

    QString toString() const;
    void fromString(const QString& zone);
    static QStringList names();

    Point2D reference() const;

    uint hash() const {return static_cast<uint>(_y*61+_x);}
    static QString parsingErrorMessage(const QString& badUtmZone);
  private:
    void check();

    int _x, _y;
  };

  inline UtmZone::UtmZone()
  {
    _x=-1;
    _y=-1;
  }

 inline bool UtmZone::operator==(const UtmZone& o) const
 {
   // All latitude bands share the Y scale starting zero at equator.
   return _x==o._x;
 }

 inline bool UtmZone::operator!=(const UtmZone& o) const
 {
   // All latitude bands share the Y scale starting zero at equator.
   return _x!=o._x;
 }

 inline uint qHash(const UtmZone& z) {
   return z.hash();
 }

} // namespace QGpCoreMath

#endif // UTMZONE_H

