/***************************************************************************
**
**  This file is part of QGpCoreMath.
**
**  QGpCoreMath is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  QGpCoreMath is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2021-09-16
**  Copyright: 2021
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef TWIDDLEFACTORS_H
#define TWIDDLEFACTORS_H

#include <QGpCoreTools.h>

#include "QGpCoreMathDLLExport.h"

namespace QGpCoreMath {

  class QGPCOREMATH_EXPORT TwiddleFactors
  {
  public:
    TwiddleFactors(int n, double amp, double arg);
    ~TwiddleFactors();

    inline Complex value(int i) const;

    static bool test(int n);
    static bool testAll(int minN, int maxN);

    void print(int n);
  private:
    int _shift, _mask;
    Complex * _high, * _low;
  };

  inline Complex TwiddleFactors::value(int k) const
  {
    return _high[k >> _shift]*_low[k & _mask];
  }

} // namespace QGpCoreMath

#endif // TWIDDLEFACTORS_H

