/***************************************************************************
**
**  This file is part of QGpCoreMath.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2009-07-01
**  Copyright: 2009-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef STATISTICS_H
#define STATISTICS_H

#include <QtCore>

#include "QGpCoreMathDLLExport.h"

namespace QGpCoreMath {

  class QGPCOREMATH_EXPORT Statistics
  {
  public:
    Statistics() {reset();}

    void add(double val, double weight=1.0);
    inline void addLog(double val, double weight=1.0);
    void reset();

    int count() const {return qRound(_sumWeight);}
    double mean() const;
    double meanLog() const {return exp(mean());}
    double variance() const;
    double variance(double average) const;
    double stddev() const;
    double stddev(double average) const;
    double varianceLog() const;
    double stddevLog() const {return exp(stddev());}
    double stddevLog(double average) const {return exp(stddev(average));}
    double relativeStddev() const {return stddev()*_sumWeight/_sum;}
    double weight() const {return _sumWeight;}
  private:
    double _sum, _sum2, _sumWeight, _sumWeight2;
  };

  inline void Statistics::addLog(double val, double weight)
  {
    add(log(val), weight);    // Geometric average can be computed
                              // without the log but only multiplications
                              // However the standard deviation requires
                              // the log of each item... hence better to sum log
  }

} // namespace QGpCoreMath

#endif // STATISTICS_H
