/***************************************************************************
**
**  This file is part of QGpCoreMath.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2006-09-25
**  Copyright: 2006-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include "StatisticalPoint.h"

namespace QGpCoreMath {

const QString RealStatisticalPoint::xmlRealStatisticalPointTag="RealStatisticalPoint";
const QString ComplexStatisticalPoint::xmlComplexStatisticalPointTag="ComplexStatisticalPoint";

/*!
  \class StatisticalPoint StatisticalPoint.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

/*!
  \fn StatisticalPoint::StatisticalPoint()
  Description of constructor still missing
*/


void ComplexStatisticalPoint::setY(double v, const CurvePointOptions * options)
{
  const AbstractComplexPointOptions * co=static_cast<const AbstractComplexPointOptions *>(options);
  Complex c=StatisticalPoint<Complex>::mean();
  if(co) {
    co->fromDouble(x(), c, v);
  } else {
    ComplexPointOptions co;
    co.fromDouble(x(), c, v);
  }
  setMean(c);
}

double ComplexStatisticalPoint::y(const CurvePointOptions * options) const
{
  const AbstractComplexPointOptions * co=static_cast<const AbstractComplexPointOptions *>(options);
  if(co) {
    return co->toDouble(x(), StatisticalPoint<Complex>::mean());
  } else {
    ComplexPointOptions co;
    return co.toDouble(x(), StatisticalPoint<Complex>::mean());
  }
}

} // namespace QGpCoreMath
