/***************************************************************************
**
**  This file is part of QGpCoreMath.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2004-03-04
**  Copyright: 2004-2019
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef SAMPLINGPARAMETERS_H
#define SAMPLINGPARAMETERS_H

#include <QGpCoreTools.h>

#include "QGpCoreMathDLLExport.h"

namespace QGpCoreMath {

  enum SamplingOption {LinearScale=0, LogScale=1, InverseScale=2, Interpole=4};
  Q_DECLARE_FLAGS(SamplingOptions, SamplingOption)

  class QGPCOREMATH_EXPORT SamplingParameters: public AbstractParameters
  {
  public:
    SamplingParameters();

    AbstractParameters * clone() const {return new SamplingParameters(*this);}

    enum ScaleType {Linear, Inverse, Log};
    enum StepType {Step, Count, ExactCount};

    ENUM_AS_STRING_DECL(ScaleType)
    ENUM_AS_STRING_DECL(StepType)

    void setScaleType(ScaleType t, bool keepCount=false);
    ScaleType scaleType() const {return _scaleType;}

    static ScaleType scaleType(SamplingOptions s);
    static SamplingOptions samplingOptions(ScaleType t);

    void setStepType(StepType t) {_stepType=t; setCount();}
    StepType stepType() const {return _stepType;}

    void setRange(double min, double max);
    void setMinimum(double m) {_min=m; setCount();}
    double minimum() const {return _min;}
    void setMaximum(double m) {_max=m; setCount();}
    double maximum() const {return _max;}
    void includeLimits();

    void setCount(int n);
    void setExactCount(int n);
    int count() const {return _n;}

    void setStep(double step);
    double step() const {return _step;}

    bool isValid() const;
    bool isValidRange(bool log) const;

    void linearize();

    bool bestFit(const VectorList<double>& values);

    double value(int i) const;
    int index(double val) const;
    VectorList<double> values() const;

    QString toUserString() const;

    QString toString(PARAMETERS_TOSTRING_ARGS_DECL) const;
    void collectKeywords(PARAMETERS_COLLECTKEYWORDS_ARGS);
  protected:
    int keywordCount(PARAMETERS_KEYWORDCOUNT_ARGS) const;
    bool setValue(PARAMETERS_SETVALUE_ARGS);
  private:
    void setCount();

    ScaleType _scaleType;
    StepType _stepType;
    int _n;
    double _min, _max, _step;
    double _minIndex;
  };

} // namespace QGpCoreMath

Q_DECLARE_OPERATORS_FOR_FLAGS(QGpCoreMath::SamplingOptions)

#endif // SAMPLINGPARAMETERS_H
