/***************************************************************************
**
**  This file is part of QGpCoreMath.
**
**  QGpCoreMath is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  QGpCoreMath is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2021-04-01
**  Copyright: 2021
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef PRIMEFACTORIZATION_H
#define PRIMEFACTORIZATION_H

#include <QGpCoreTools.h>

#include "QGpCoreMathDLLExport.h"

#define PRIMEFACTORIZATION_MAXIMUM_PRIME 1999
#define PRIMEFACTORIZATION_PRIME_COUNT 303

namespace QGpCoreMath {

  class QGPCOREMATH_EXPORT PrimeFactorization
  {
  public:
    inline PrimeFactorization();
    inline PrimeFactorization(int n);
    PrimeFactorization(const PrimeFactorization& o) : _factors(o._factors) {}

    struct Factor {
      int base;
      int exponent;
    };

    void setValue(int val);

    bool isValid() const {return _valid;}
    bool isPrime() const {return _valid && _factors.count()==1;}
    bool isSquared() const;

    int count() const {return _factors.count();}
    const Factor& factor(int index) const {return _factors.at(index);}

    int value() const;
    void sqrtLow();
    void sqrtHigh();
    void operator/=(const PrimeFactorization& o);
    QString toString() const;

    static bool isValid(int val, int maxPrime);
    static void primeList(int min, int max);
    static int closestValue(int n, int maxPrime);
    static bool test();

    static const int primes[];
  private:
    bool _valid;
    VectorList<Factor> _factors;
  };

  inline PrimeFactorization::PrimeFactorization()
  {
    _valid=true;
  }

  inline PrimeFactorization::PrimeFactorization(int n)
  {
    setValue(n);
  }

} // namespace QGpCoreMath

#endif // PRIMEFACTORIZATION_H

