/***************************************************************************
**
**  This file is part of QGpCoreMath.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2010-06-07
**  Copyright: 2010-2019
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef PLANE_H
#define PLANE_H

#include "QGpCoreMathDLLExport.h"
#include "Point.h"

namespace QGpCoreMath {

class QGPCOREMATH_EXPORT Plane
{
  TRANSLATIONS("Plane");
public:
  Plane() {_d=0.0;}
  Plane(const Point& normal, const Point& reference);
  Plane(const Plane& o);

  void setReference(int index, const Point& p) {ASSERT(index<3); _references[index]=p;}
  bool setReferences(const VectorList<Point>& p);

  void setZ(int index, double z) {ASSERT(index<3); _references[index].setZ(z);}

  bool setNormalVector();
  void setNormalVectorXY();

  inline double z(const Point& at);
  double d() const {return _d;}
  const Point& normalVector() const {return _normalVector;}
  const Point& directionalVector(int index) const {return _directionalVector[index];}
  bool includes(const Point& p) const;
private:
  Point _references[3];
  Point _directionalVector[2];
  Point _normalVector;
  double _d;
};

double Plane::z(const Point& at)
{
  return (_d-_normalVector.x()*at.x()-_normalVector.y()*at.y())/_normalVector.z();
}

} // namespace QGpCoreMath

#endif // PLANE_H
