/***************************************************************************
**
**  This file is part of QGpCoreMath.
**
**  QGpCoreMath is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  QGpCoreMath is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2023-04-03
**  Copyright: 2023
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef MULTIVARIATESTATISTICS_H
#define MULTIVARIATESTATISTICS_H

#include "QGpCoreMathDLLExport.h"
#include "PrivateVector.h"
#include "DoubleMatrix.h"

namespace QGpCoreMath {

  class QGPCOREMATH_EXPORT MultivariateStatistics
  {
  public:
    MultivariateStatistics(int dim);
    ~MultivariateStatistics();

    void add(const Vector<double>& val, double weight=1.0);

    int dimensionCount() const {return _sum.count();}
    void mean(Vector<double>& m) const;
    DoubleMatrix variance() const;
  private:
    PrivateVector<double> _sum;
    DoubleMatrix _sum2;
    double _sumWeight, _sumWeight2;
  };

} // namespace QGpCoreMath

#endif // MULTIVARIATESTATISTICS_H

