/***************************************************************************
**
**  This file is part of QGpCoreMath.
**
**  QGpCoreMath is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  QGpCoreMath is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2023-09-15
**  Copyright: 2023
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef MISFIT_H
#define MISFIT_H

#include <QGpCoreTools.h>

#include "QGpCoreMathDLLExport.h"

namespace QGpCoreMath {

  class QGPCOREMATH_EXPORT Misfit
  {
  public:
    enum Type {L1, L1_Normalized, L1_LogNormalized, L1_NormalizedBySigmaOnly,
               L2, L2_Normalized, L2_LogNormalized, L2_Inverse, L2_NormalizedBySigmaOnly,
               RMS, Akaike, AkaikeFewSamples, Determinant, TypeCount};
    ENUM_AS_STRING_DECL(Type)

    static QStringList types();
  };

} // namespace QGpCoreMath

#endif // MISFIT_H

