/***************************************************************************
**
**  This file is part of QGpCoreMath.
**
**  QGpCoreMath is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  QGpCoreMath is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2020-06-04
**  Copyright: 2020
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef LEASTSQUARE_H
#define LEASTSQUARE_H

#include "QGpCoreMathDLLExport.h"
#include "DoubleMatrix.h"
#include "SamplingParameters.h"

namespace QGpCoreMath {

  class QGPCOREMATH_EXPORT LeastSquare
  {
  public:
    LeastSquare(int dataCount, int order);
    ~LeastSquare();

    void setScaleType(const SamplingParameters::ScaleType& t) {_scaleType=t;}
    void setData(int index, double x, double y);
    void invert() {*_x=_a->leastSquare(*_b);}
    double value(double x) const;
  private:
    DoubleMatrix * _a, * _b, * _x;
    SamplingParameters::ScaleType _scaleType;
  };

} // namespace QGpCoreMath

#endif // LEASTSQUARE_H

