/***************************************************************************
**
**  This file is part of QGpCoreMath.
**
**  QGpCoreMath is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  QGpCoreMath is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2021-06-10
**  Copyright: 2021
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "FunctionSearchMaximum.h"

namespace QGpCoreMath {

  double FunctionSearchMaximum::_relativePrecision=0.0;
  double FunctionSearchMaximum::_relativePrecision2=0.0;
  /*!
    \class FunctionSearchMaximum FunctionSearchMaximum.h
    \brief Brief description of class still missing

    Full description of class still missing
  */

  /*!
    This function is not thread safe.
  */
  void FunctionSearchMaximum::setRelativePrecision(double p)
  {
    _relativePrecision=p;
    _relativePrecision2=p*p;
  }

  /*!
    Before using this function in a quick sort, set the correct relative precision.
  */
  bool FunctionSearchMaximum::lessThanPos(const FunctionSearchMaximum *v1,
                                          const FunctionSearchMaximum *v2)
  {
    int n=v1->_dimensionCount-1;
    for(int i=0; i<n; i++) {
      double dx=v1->_position[i]-v2->_position[i];
      if(fabs(dx)>=fabs(v1->_position[i])*_relativePrecision) {
        return dx<0.0;
      }
    }
    return v1->_position[n]-v2->_position[n]<0.0;
  }

  /*!
    Before using this function in a quick sort, set the correct relative precision.
  */
  bool FunctionSearchMaximum::equalPos(const FunctionSearchMaximum *v1,
                                       const FunctionSearchMaximum *v2)
  {
    double abs1=0.0, absDiff=0.0, dx;
    int n=v1->_dimensionCount;
    for(int i=0; i<n; i++) {
      dx=v1->_position[i];
      abs1+=dx*dx;
      dx-=v2->_position[i];
      absDiff+=dx*dx;
    }
    return absDiff<abs1*_relativePrecision2;
  }

} // namespace QGpCoreMath

