/***************************************************************************
**
**  This file is part of QGpCoreMath.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2007-11-12
**  Copyright: 2007-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef DIRECTIONALSEARCH_H
#define DIRECTIONALSEARCH_H

#include "QGpCoreMathDLLExport.h"
#include "FunctionSearch.h"

namespace QGpCoreMath {

class QGPCOREMATH_EXPORT DirectionalSearch : public FunctionSearch
{
public:
  DirectionalSearch();
  ~DirectionalSearch();

  void setAzimuth(double azimuth);
  void setGrid(double min, double max, double step);

  void globalMax(double absThres);
  void localMax(int nMax, double absThres, double relThres);
private:
  double refineMax(double val);
  inline void setCurrentPosition(int i);

  double _cx, _sy;
  int _count;
  double _min, _step;
};

} // namespace QGpCoreMath

#endif // DIRECTIONALSEARCH_H
