/***************************************************************************
**
**  This file is part of QGpCoreMath.
**
**  QGpCoreMath is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  QGpCoreMath is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2021-01-13
**  Copyright: 2021
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef DELAUNAYTRIANGULATION_H
#define DELAUNAYTRIANGULATION_H

#include "QGpCoreMathDLLExport.h"
#include "Triangle.h"
#include "Curve.h"
#include "Rect.h"

namespace QGpCoreMath {

  class DelaunayTriangle: public Triangle
  {
  public:
    inline DelaunayTriangle() {}
    inline DelaunayTriangle(const Point2D& a, const Point2D& b, const Point2D& c);
    inline DelaunayTriangle(const Triangle& o);

    void super(const QList<Point2D>& points);

    inline void setCircumcircle();
    const Circle& circumcircle() const {return _circumcircle;}

    inline void setSurface();
    double surface() const {return _surface;}
  private:
    Circle _circumcircle;
    double _surface;
  };

  inline DelaunayTriangle::DelaunayTriangle(const Point2D& a, const Point2D& b, const Point2D& c)
    : Triangle(a, b, c)
  {
    setCircumcircle();
    setSurface();
  }

  inline DelaunayTriangle::DelaunayTriangle(const Triangle& o)
    : Triangle(o)
  {
    setCircumcircle();
    setSurface();
  }

  inline void DelaunayTriangle::setCircumcircle()
  {
    bool ok=true;
    _circumcircle=Triangle::circumcircle(ok);
  }

  inline void DelaunayTriangle::setSurface()
  {
    _surface=Triangle::surface();
  }

  class QGPCOREMATH_EXPORT DelaunayTriangulation
  {
  public:
    DelaunayTriangulation();
    ~DelaunayTriangulation();

    void init(const QList<Point2D>& points);

    VectorList<DelaunayTriangle> triangles(const Point2D& p) const;
    VectorList<Curve<Point2D>> triangleEdges() const;
    VectorList<Curve<Point2D>> voronoiCells(const Rect& limits) const;

    double surface() const;
  private:
    struct Edge {
      Point2D p1, p2;
    };

    int indexOf(const Edge& edge, const VectorList<int>& triangles, int current) const;
    Point2D segmentEnd(const Edge& edge, const Point& vertex, const Point2D& center,
                       int index, const VectorList<int>& triangleIndexes,
                       const Rect& limits) const;

    VectorList<DelaunayTriangle> _triangles;
  };

} // namespace QGpCoreMath

#endif // DELAUNAYTRIANGULATION_H

