/***************************************************************************
**
**  This file is part of QGpCoreMath.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2010-05-19
**  Copyright: 2010-2019
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef COMPLEXPOINTOPTIONS_H
#define COMPLEXPOINTOPTIONS_H

#include "AbstractComplexPointOptions.h"
#include "QGpCoreMathDLLExport.h"

namespace QGpCoreMath {

class QGPCOREMATH_EXPORT ComplexPointOptions : public AbstractComplexPointOptions
{
public:
  enum OutputMode {AbsoluteValue, Phase, Real, Imaginary};

  ComplexPointOptions(OutputMode m=AbsoluteValue) : AbstractComplexPointOptions() {_mode=m;}
  ComplexPointOptions(const ComplexPointOptions& o) : AbstractComplexPointOptions() {_mode=o._mode;}

  void setMode(OutputMode m) {_mode=m;}
  OutputMode mode() const {return _mode;}

  virtual double toDouble(double x, const Complex& c) const;
  virtual void fromDouble(double x, Complex& c, double v) const;
protected:
  OutputMode _mode;
};

} // namespace QGpCoreMath

#endif // COMPLEXPOINTOPTIONS_H
