/***************************************************************************
**
**  This file is part of QGpCoreMath.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2017-12-07
**  Copyright: 2017-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef AVERAGEANGLE_H
#define AVERAGEANGLE_H

#include "QGpCoreMathDLLExport.h"
#include "Angle.h"

namespace QGpCoreMath {

  class QGPCOREMATH_EXPORT AverageAngle
  {
  public:
    AverageAngle();
    ~AverageAngle() {}

    void clear();
    void addDegrees(double angle);
    void addRadians(double angle);

    double averageRadians() const;
    double averageDegrees() const;
  private:
    double _sum;
    int _count;
  };

} // namespace QGpCoreMath

#endif // AVERAGEANGLE_H

