/***************************************************************************
**
**  This file is part of QGpCompatibility.
**
**  QGpCompatibility is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  QGpCompatibility is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2004-10-22
**  Copyright: 2004-2019
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef COMPATMODALREFINEDCURVES_H
#define COMPATMODALREFINEDCURVES_H

#include "CompatModalCurves.h"
#include "CompatModalRefine.h"
#include "CompatModalFrequency.h"
#include "QGpCompatibilityDLLExport.h"

namespace QGpCompatibility {

typedef QList<CompatModalRefine> CompatRefineList;
typedef QList<CompatModalRefine>::iterator CompatRefineIterator;
typedef QList<CompatModalRefine>::const_iterator CompatRefineConstIterator;

class QGPCOMPATIBILITY_EXPORT CompatModalRefinedCurves : public CompatModalFrequency
{
public:
  void operator=(CompatModalRefinedCurves& o);

  void setNOmegas(int nf);
  virtual void setNModes(int nm) {_curves.setNModes(nm);}
  int nModes() const {return _curves.nModes();}

  // Access to curves
  CompatVDataPointVector& mode(int im) {return _curves.mode(im);}
  const CompatVDataPointVector& mode(int im) const {return _curves.mode(im);}

  // Output
  VectorList<double> * meanVector(int im) {return _curves.meanVector(im);}
  VectorList<double> * stddevVector(int im) {return _curves.stddevVector(im);}
  VectorList<double> * weightVector(int im) {return _curves.weightVector(im);}
  int toPointVector(int imode, Point2D *& pointList);
  VectorList<Point> * toPointVector(int imode);
  void toStream(FILE *f);

  virtual void addRayleighModes(int nNewModes);
  void addInvalidSamples(CompatModalFrequency * samples);

  void clearRefines() {_refines.clear();}
  int nRefines() const {return _refines.size();}
  void refineSort() {std::sort(_refines.begin(), _refines.end());}

  void writeReport(QDataStream& s) const;
protected:
  CompatModalCurves _curves;
  CompatRefineList _refines;
protected:
  virtual void insertInvalidAt(int i) {_curves.insertInvalidAt(i);}
  virtual void addInvalid() {_curves.addInvalid();}
  virtual const QString& xml_tagName() const {return xmlModalRefinedCurvesTag;}
  static const QString xmlModalRefinedCurvesTag;
  virtual void xml_writeChildren(XML_WRITECHILDREN_ARGS) const;
  virtual XMLMember xml_member(XML_MEMBER_ARGS);
};

inline void CompatModalRefinedCurves::setNOmegas(int nf)
{
  TRACE;
  CompatModalFrequency::setNOmegas(nf);
  _curves.setNOmegas(nf);
}

} // namespace QGpCompatibility

#endif // COMPATMODALREFINEDCURVES_H
