/***************************************************************************
**
**  This file is part of QGpCompatibility.
**
**  QGpCompatibility is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  QGpCompatibility is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2004-10-22
**  Copyright: 2004-2019
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef COMPATMODALELLIPTICITY_H
#define COMPATMODALELLIPTICITY_H

#include <QGpCoreWave.h>
#include "QGpCompatibilityDLLExport.h"
#include "CompatModalRefinedCurves.h"

namespace QGpCompatibility {

class CompatEllipticityData;
class CompatModalDispersion;

#define COMPATMODALELLIPTICITY_INVALID_VALUE -999999.0

class QGPCOMPATIBILITY_EXPORT CompatModalEllipticity :  public CompatModalRefinedCurves
{
  TRANSLATIONS( "CompatModalEllipticity" );
public:
  CompatModalEllipticity() {_curves.setInvalidValue(COMPATMODALELLIPTICITY_INVALID_VALUE);}
  
  void operator=(CompatModalEllipticity& o);
  // To be removed in the future, when Dinver will be completly finished
  CompatEllipticityData * oldStyle();

  virtual void setNModes(int nm) {
    CompatModalRefinedCurves::setNModes(nm);
    setNRayleighModes(nm);
  }

  CompatVDataPoint& f0() {return _f0;}

  void setPeakFrequencyMisfit(bool pfm) {_peakFrequencyMisfit=pfm;}
  bool peakFrequencyMisfit() {return _peakFrequencyMisfit;}

  double misfit() {return misfit(0,nOmegas()-1);}
  double misfit(int iMin, int iMax);
  double frequencyMisfit(CompatModalDispersion& disp, Rayleigh& model);
protected:
  virtual const QString& xml_tagName() const {return xmlModalEllipticityTag;}
  static const QString xmlModalEllipticityTag;
  virtual void xml_writeProperties(XML_WRITEPROPERTIES_ARGS) const;
  virtual void xml_writeChildren(XML_WRITECHILDREN_ARGS) const;
  virtual XMLMember xml_member(XML_MEMBER_ARGS);
  bool xml_setProperty(XML_SETPROPERTY_ARGS);
private:
  bool _peakFrequencyMisfit;
  CompatVDataPoint _f0;
};

} // namespace QGpCompatibility

#endif // COMPATMODALELLIPTICITY_H
