/***************************************************************************
**
**  This file is part of HVGui.
**
**  HVGui is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  HVGui is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2005-10-10
**  Copyright: 2005-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include "StudentTest.h"
#include "StudentTestCurveModel.h"

namespace HVGui {

  StudentTest::StudentTest(QWidget *parent, Qt::WindowFlags f)
      : Dialog(parent, f)
  {
    TRACE;
    setupUi(this);
  }

  void StudentTest::init(const ResultLists& curves)
  {
    TRACE;
    StudentTestCurveModel * model=new StudentTestCurveModel(this);
    model->setList(curves);
    firstCurveList->setModel(model);
    firstCurveList->setSelectionBehavior(QAbstractItemView::SelectRows);
    firstCurveList->setSelectionMode(QAbstractItemView::SingleSelection);
    firstCurveList->header()->hide();
    firstCurveList->expandAll();
    secondCurveList->setModel(model);
    secondCurveList->setSelectionBehavior(QAbstractItemView::SelectRows);
    secondCurveList->setSelectionMode(QAbstractItemView::SingleSelection);
    secondCurveList->header()->hide();
    secondCurveList->expandAll();
  }

  CurveResults * StudentTest::firstCurve() const
  {
    TRACE;
    StudentTestCurveModel * model=static_cast<StudentTestCurveModel *>(firstCurveList->model());
    QModelIndex index=firstCurveList->currentIndex();
    return model->results(index);
  }

 CurveResults * StudentTest::secondCurve() const
  {
    TRACE;
    StudentTestCurveModel * model=static_cast<StudentTestCurveModel *>(secondCurveList->model());
    QModelIndex index=secondCurveList->currentIndex();
    return model->results(index);
  }

  void StudentTest::on_makeUpBrowse_clicked()
  {
    TRACE;
    QString s=Message::getOpenFileName(tr("Make-up for results"), tr("Sheet make-up (*.mkup)"));
    if(s.length()>0) makeUpFile->setText(s);
  }

} // namespace HVGui
