/***************************************************************************
**
**  This file is part of HVCore.
**
**  HVCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  HVCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2020-02-18
**  Copyright: 2020
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "HVWorker.h"
#include "HVTask.h"
#include "HVStation.h"

namespace HVCore {

  /*!
    \class HVWorker HVWorker.h
    \brief Brief description of class still missing

    Full description of class still missing
  */

  /*!
    Description of constructor still missing
  */
  HVWorker::HVWorker()
    : ParallelTaskWorker()
  {
    TRACE;
    _signals=nullptr;
  }

  /*!
    Description of destructor still missing
  */
  HVWorker::~HVWorker()
  {
    TRACE;
    delete _signals;
  }

  void HVWorker::process(ParallelTask * t)
  {
    HVTask * hvt=static_cast<HVTask *>(t);
    const HVParameters * param=taskManager()->parameters();
    while(!terminated()) {
      if(!t->hasStepToProcess()) {
        t->setFinishing();
        break;
      } else {
        int windowIndex=t->currentStep();
        t->addSteps(1);
        t->beginProcess(); // Avoid removal of task
        t->unlock();

        if(!_signals) {
          _signals=hvt->station()->createProcessSignals();
        }
        hvt->station()->process(_signals, windowIndex, param);

        t->lock();
        t->endProcess();
      }
    }
    t->unlock();
  }

  void HVWorker::polish(ParallelTask * t)
  {
    HVTask * hvt=static_cast<HVTask *>(t);
    App::log(tr("Get statistics...\n"));
    int n=hvt->station()->resultCount();
    for(int i=0; i<n; i++) {
      AbstractResults * r=hvt->station()->results(i);
      r->setStatistics();
      r->setPeaks();
    }
  }

} // namespace HVCore

