/***************************************************************************
**
**  This file is part of HVCore.
**
**  HVCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  HVCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2007-05-11
**  Copyright: 2007-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef HVSTATIONSIGNALS_H
#define HVSTATIONSIGNALS_H

#include <GeopsyCore.h>

#include "HVCoreDLLExport.h"
#include "HVParameters.h"
#include "HVCoreDLLExport.h"

namespace HVCore {

  class HVCORE_EXPORT HVStationSignals : public StationProcessSignals
  {
  public:
    HVStationSignals() : StationProcessSignals(3) {}
    ~HVStationSignals();

    bool setProcessed(const StationProcessSignals * from,
                      const TimeRange& tw, const AbstractParameters * param);

    const Curve<Point2D>& vertical() const {return _verticalSpectrum;}
    Curve<Point2D> horizontal(const HVParameters * param, double factor=1.0);
    Curve<Point2D> horizontalGeometric(const HVParameters * param);
    Curve<Point2D> horizontal(double azimuth, const HVParameters * param);
  private:
    bool fft(const StationProcessSignals * from, int icomp,
             const TimeRange& tw, const HVParameters * param);

    Curve<Point2D> _verticalSpectrum;
  };
}

#endif // HVSTATIONSIGNALS_H
