/***************************************************************************
**
**  This file is part of GeopsyPySciFigs.
**
**  GeopsyPySciFigs is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  GeopsyPySciFigs is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2023-11-21
**  Copyright: 2023
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifdef HAS_PYTHON
#include "PythonNumPy.h"

#include <SciFigs.h>

#include "CurveData.h"
#include "GraphicalUserInterface.h"

/*!
  \class CurveData CurveData.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

/*!
  Description of constructor still missing
*/
CurveData::CurveData()
{
  TRACE;
  NUMPY_IMPORT_ARRAY
}

/*!
  Description of destructor still missing
*/
CurveData::~CurveData()
{
  TRACE;
}

PyArrayObject * CurveData::toArray(PyObject * obj, const QString& arrayName)
{
  PyArrayObject * array=(PyArrayObject *) PyArray_FROM_OTF(obj, NPY_DOUBLE, NPY_ARRAY_IN_ARRAY);
  if(array==NULL) {
    GraphicalUserInterface::setErrorMessage(tr("object for %1 argument must be a numpy array.").arg(arrayName));
    return NULL;
  }
  return array;
}

bool CurveData::setArguments(PyObject * argX, PyObject * argY)
{
  if(argX==NULL) {
    if(argY==NULL) {
      _nSamples=0;
      _nCurves=0;
    } else {
      GraphicalUserInterface::setErrorMessage(tr("X vector is missing."));
      return false;
    }
  } else {
    if(argY==NULL) {
      GraphicalUserInterface::setErrorMessage(tr("Y vector is missing."));
      return false;
    } else {
      _x=toArray(argX, "X");
      if(_x==NULL) {
        return false;
      }
      if(PyArray_NDIM(_x)!=1) {
        GraphicalUserInterface::setErrorMessage(tr("dimension of X array must be 1."));
        return NULL;
      }
      _y=toArray(argY, "Y");
      if(_y==NULL) {
        return false;
      }
      npy_intp * dims;
      dims=PyArray_DIMS(_x);
      _nSamples=dims[0];
      dims=PyArray_DIMS(_y);
      switch(PyArray_NDIM(_y)) {
      case 1:
        _nCurves=1;
        if(_nSamples!=dims[0]) {
          GraphicalUserInterface::setErrorMessage(tr("X and Y vectors must have the same dimension."));
          return false;
        }
        break;
      case 2:
        _nCurves=dims[0];
        if(_nSamples!=dims[1]) {
          GraphicalUserInterface::setErrorMessage(tr("X and Y vectors must have the same dimension."));
          return false;
        }
        break;
      default:
        GraphicalUserInterface::setErrorMessage(tr("Y must have 1 or 2 dimensions."));
        return false;
      }
    }
  }
  return true;
}

void CurveData::addTo(LineLayer * layer, Legend * legend) const
{
  double * x=(double *)PyArray_DATA(_x);
  double * y=(double *)PyArray_DATA(_y);
  for(int iCurve=0; iCurve<_nCurves; iCurve++) {
    int index=layer->count();
    PlotLine * line=static_cast<PlotLine *>(layer->addLine());
    if(legend) {
      line->setPen(legend->pen(index));
      line->setSymbol(legend->symbol(index));
    }
    Curve<Point>& curve=line->curve();
    curve.resize(_nSamples);
    for(int i=0; i<_nSamples; i++) {
      curve.setX(i, x[i]);
      curve.setY(i, y[i]);
    }
    y+=_nSamples;
  }
}

#endif // HAS_PYTHON
