/***************************************************************************
**
**  This file is part of GeopsyPySciFigs.
**
**  GeopsyPySciFigs is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  GeopsyPySciFigs is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2023-11-21
**  Copyright: 2023
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef ACTIONREQUEST_H
#define ACTIONREQUEST_H

#ifdef HAS_PYTHON
#include "PythonNumPy.h"

#include <QtCore>

class ActionExecute;
class CurveData;
class MethodArgument;

class ActionRequest : public QObject
{
  Q_OBJECT
public:
  ActionRequest();
  ~ActionRequest();

  void connectTo(ActionExecute * a);

  int createGraphicSheet();
  int createAxisWindow(int parentId);
  void addCurves(int parentId, const CurveData * d);
  QVariant propertyValue(int objectId, int propertyId);
  bool setPropertyValue(int objectId, int propertyId, PyObject * args);
  MethodArgument * method(int objectId, int methodId, PyObject * args);
  void setVerbosity(int level);
  void quit();
signals:
  void requestCreateGraphicSheet(int * objectId);
  void requestCreateAxisWindow(int parentId, int * objectId);
  void requestAddCurves(int parentId, const CurveData * d);
  void requestPropertyValue(int objectId, int propertyId, QVariant * val);
  void requestSetPropertyValue(int objectId, int propertyId, PyObject * args, bool * ok);
  void requestMethod(int objectId, int methoddId, PyObject * args, MethodArgument ** val);
  void requestSetVerbosity(int level);
  void requestQuit();
private:
  void waitAcknowledge();

  QMutex _acknowledgeMutex;
  QWaitCondition _acknowledge;
};

#endif // HAS_PYTHON
#endif // ACTIONREQUEST_H

