/***************************************************************************
**
**  This file is part of GeopsyLand.
**
**  GeopsyLand is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  GeopsyLand is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2018-12-06
**  Copyright: 2018-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef TERMINALPROCESS_H
#define TERMINALPROCESS_H

#include <QGpCoreTools.h>

class MiniBash;

class TerminalProcess: public Thread
{
  Q_OBJECT
public:
  TerminalProcess(MiniBash * shell);
  ~TerminalProcess();

  enum OutputType {Standard, Pipe, FileNew, FileAppend};

  const QString& name() const {return _name;}
  void setName(const QString& n) {_name=n;}
  bool resolvePath(const QStringList& paths, MiniBash * shell);

  const QStringList& arguments() const {return _arguments;}
  void clearArguments() {_arguments.clear();}
  void addArgument(const QString& a);

  void setInputProcess(TerminalProcess * p) {_inputTerminalProcess=p;}
  void setInputFile(const QString& f) {_inputFile=f;}
  void setOutputProcess(TerminalProcess * p) {_outputTerminalProcess=p; _outputType=Pipe;}
  void setOutputType(OutputType o) {_outputType=o;}

  void setDetached(bool d) {_detached=d;}
  bool isDetached() const {return _detached;}

  void start();
  bool isRunning();
  void kill();

  void closeStandardOutput();
  void standardInput(const QByteArray& data);

  static void addDirMark(QStringList& list);
protected:
  virtual void run();
private slots:
  void processStandardOutput();
  void processStandardError();
  void standardOutput(const QString& data);
  void standardOutput(const QStringList& data);
  void standardError(const QString& data);
signals:
  void sendStandardOutput(const QString& data);
  void sendStandardOutput(const QStringList& data);
  void sendStandardError(const QString& data);
  void finished();
  void exit();
private:
  enum TerminalProcessType{File, Cat, Ls, Echo, Cd, Cp, Mv, Rm, Mkdir, Head, Tail, Pwd, Exit, Help};
  TerminalProcessType typeFromName() const;
  void standardOutput(const QByteArray& data);
  void standardError(const QByteArray& data);

  MiniBash * _shell;
  QString _name;
  TerminalProcessType _type;
  QStringList _arguments;

  TerminalProcess * _inputTerminalProcess;
  QString _inputFile;
  TerminalProcess * _outputTerminalProcess;
  QString _outputFile;
  OutputType _outputType;
  bool _detached;

  QProcess * _external;
};

#endif // TERMINALPROCESS_H

