/***************************************************************************
**
**  This file is part of GeopsyGui.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2021-05-18
**  Copyright: 2021
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef PICKPARAMETERWIDGET_H
#define PICKPARAMETERWIDGET_H

#include <QtWidgets>
#include <GeopsyCore.h>

#include "GeopsyGuiDLLExport.h"

namespace Ui {
  class PickParameterWidget;
}

namespace GeopsyGui {

  class GEOPSYGUI_EXPORT PickParameterWidget : public QWidget
  {
    Q_OBJECT
  public:
    PickParameterWidget(QWidget *parent=nullptr);
    ~PickParameterWidget();

    void updateAllFields();

    void getParameters(PickParameters & param) const;
    void setParameters(const PickParameters & param);
  private slots:
    void on_amplitudeRelative_currentIndexChanged(int);
  signals:
    void parametersChanged();
  private:
    Ui::PickParameterWidget * _ui;
  };

} // namespace GeopsyGui

#endif // PICKPARAMETERWIDGET_H
