/***************************************************************************
**
**  This file is part of GeopsyCore.
**
**  GeopsyCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  GeopsyCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2013-03-02
**  Copyright: 2013-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "StationGroup.h"
#include "SignalGroupFactory.h"
#include "SubSignalPool.h"

namespace GeopsyCore {

  /*!
    \class StationGroup StationGroup.h
    \brief A group that contains the 3 components of a station

    Full description of class still missing
  */

  const QString StationGroup::xmlStationGroupTag="StationGroup";

  REGISTER_SIGNALGROUP(StationGroup, StationGroup::xmlStationGroupTag)

  bool StationGroup::xml_inherits(const QString& tagName) const
  {
    if(tagName==xmlStationGroupTag) {
      return true;
    } else {
      return AbstractSignalGroup::xml_inherits(tagName);
    }
  }

  QString StationGroup::name() const
  {
    SubSignalPool sp=subPool();
    QString n;
    bool wrongNames=false;
    for(SubSignalPool::iterator it=sp.begin(); it!=sp.end(); it++) {
      if(n.isEmpty()) {
        n=(*it)->name();
      } else {
        if(n!=(*it)->name()) {
          wrongNames=true;
        }
      }
    }
    if(wrongNames) {
      n+=" ! Check signal names !";
    }
    return n;
  }

} // namespace GeopsyCore
