/***************************************************************************
**
**  This file is part of GeopsyCore.
**
**  GeopsyCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  GeopsyCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2009-02-14
**  Copyright: 2009-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include "SignalExpressionContext.h"
#include "SignalExpression.h"

namespace GeopsyCore {

/*!
  \class SignalExpressionContext SignalExpressionContext.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

/*!
  Description of constructor still missing
*/
SignalExpressionContext::SignalExpressionContext()
    : ExpressionContext()
{
  TRACE;
  QStringList names=MetaDataFactory::instance()->registeredNames();
  QList<MetaDataIndex> indexes=MetaDataFactory::instance()->registeredData();
  int n=names.count();
  ASSERT(n==indexes.count());
  for(int i=0; i<n; i++) {
    addVariable(names.at(i), new SignalExpression(indexes.at(i), this));
  }
}

} // namespace GeopsyCore
