/***************************************************************************
**
**  This file is part of GeopsyCore.
**
**  GeopsyCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  GeopsyCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2018-11-06
**  Copyright: 2018-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef SEISMICEVENT_H
#define SEISMICEVENT_H

#include <QGpCoreMath.h>
#include "GeopsyCoreDLLExport.h"

namespace GeopsyCore {

  class GEOPSYCORE_EXPORT SeismicEvent : public XMLClass
  {
  public:
    SeismicEvent();
    SeismicEvent(const SeismicEvent& o);
    ~SeismicEvent();

    const QString& xml_tagName() const {return xmlSeismicEventTag;}
    static const QString xmlSeismicEventTag;

    void operator=(const SeismicEvent& o);
    bool operator==(const SeismicEvent& o) const;
    bool isSamePosition(const SeismicEvent& o) const;

    const QString& name() const {return _name;}
    void setName(const QString& n) {_name=n;}

    const Point& position() const {return _position;}
    void setPosition(const Point& p) {_position=p;}

    const UtmZone& utmZone() const {return _utmZone;}
    void setUtmZone(const UtmZone& z) {_utmZone=z;}

    const DateTime& time() const {return _time;}
    void setTime(const DateTime& t) {_time=t;}

    double duration() const {return _duration;}
    void setDuration(double d) {_duration=d;}

    const DateTime& key() const {return time();}

    enum Type {Hammer, Explosion, WeightDrop, Steps, Earthquake};
    ENUM_AS_STRING_DECL(Type)

    Type type() const {return _type;}
    void setType(Type t) {_type=t;}

    static QString userType(Type t);
    static Type userType(QString t, bool * ok);
    static QStringList userTypes();

    const Point& force() const {return _force;}
    void setForce(const Point& f) {_force=f;}

    QString name(int posPrec, int timePrec) const;

    static bool lessThan(const SeismicEvent * e1, const SeismicEvent * e2);

    void lock() const {++_lock;}
    void unlock() const {--_lock;}
    bool isLocked() const {return _lock!=0;}

    // XML serialization
    void xml_writeProperties(XML_WRITEPROPERTIES_ARGS) const;
    bool xml_setProperty(XML_SETPROPERTY_ARGS);
    XMLMember xml_member(XML_MEMBER_ARGS);
  private:
    QString _name;
    Point _position;
    UtmZone _utmZone;

    DateTime _time;
    double _duration;
    Point _force;
    Type _type;

    mutable QAtomicInt _lock;
  };

} // namespace GeopsyCore

#endif // SEISMICEVENT_H

