/***************************************************************************
**
**  This file is part of GeopsyCore.
**
**  GeopsyCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  GeopsyCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2009-03-29
**  Copyright: 2009-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef ROTATEPARAMETERS_H
#define ROTATEPARAMETERS_H

#include <QGpCoreMath.h>

#include "GeopsyCoreDLLExport.h"

namespace GeopsyCore {

class GEOPSYCORE_EXPORT RotateParameters : public AbstractParameters
{
public:
  RotateParameters();
  RotateParameters(const RotateParameters& o);

  virtual AbstractParameters * clone() const {return new RotateParameters(*this);}

  enum Axis {None=0x00, Vertical=0x01, North=0x02, East=0x04};
  Q_DECLARE_FLAGS(Axes, Axis)

  Axes axes() const {return _axes;}
  void setAxes(Axes a) {_axes=a;}

  double angleAroundVertical() const {return _angleAroundVertical;}
  void setAngleAroundVertical(double a) {_angleAroundVertical=a;}

  double angleAroundNorth() const {return _angleAroundNorth;}
  void setAngleAroundNorth(double a) {_angleAroundNorth=a;}

  double angleAroundEast() const {return _angleAroundEast;}
  void setAngleAroundEast(double a) {_angleAroundEast=a;}

  Matrix3x3 matrix() const;
private:
  Axes _axes;
  double _angleAroundVertical;
  double _angleAroundNorth;
  double _angleAroundEast;
};

} // namespace GeopsyCore

Q_DECLARE_OPERATORS_FOR_FLAGS(GeopsyCore::RotateParameters::Axes)

#endif // ROTATEPARAMETERS_H
