/***************************************************************************
**
**  This file is part of GeopsyCore.
**
**  GeopsyCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  GeopsyCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2021-05-18
**  Copyright: 2021
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef PICKPARAMETERS_H
#define PICKPARAMETERS_H

#include <QGpCoreTools.h>

#include "GeopsyCoreDLLExport.h"

namespace GeopsyCore {

  class GEOPSYCORE_EXPORT PickParameters : public AbstractParameters
  {
  public:
    PickParameters();
    PickParameters(const PickParameters& o);

    virtual AbstractParameters * clone() const {return new PickParameters(*this);}

    enum AmplitudeThreshold {NoAmplitudeThreshold, RelativeAmplitudeThreshold, AbsoluteAmplitudeThreshold};

    void setAmplitudeThresholdType(AmplitudeThreshold t) {_amplitudeThresholdType=t;}
    bool setAmplitudeThresholdType(const QString& t);
    AmplitudeThreshold amplitudeThresholdType() const {return _amplitudeThresholdType;}
    QString amplitudeThresholdTypeString() const;

    double amplitudeThreshold() const {return _amplitudeThresholdValue;}
    void setAmplitudeThreshold(double t) {_amplitudeThresholdValue=t;}

    double holdOffDelay() const {return _holdOffDelay;}
    void setHoldOffDelay(double d);

    QString toString(PARAMETERS_TOSTRING_ARGS_DECL) const;
    void collectKeywords(PARAMETERS_COLLECTKEYWORDS_ARGS);
  protected:
    int keywordCount(PARAMETERS_KEYWORDCOUNT_ARGS) const;
    bool setValue(PARAMETERS_SETVALUE_ARGS);
  private:
    AmplitudeThreshold _amplitudeThresholdType;
    double _amplitudeThresholdValue;

    double _holdOffDelay;
  };

} // namespace GeopsyCore

#endif // PICKPARAMETERS_H

