/***************************************************************************
**
**  This file is part of GeopsyCore.
**
**  GeopsyCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  GeopsyCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2007-09-20
**  Copyright: 2007-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include <QGpCoreTools.h>
#include "MorletParameters.h"

namespace GeopsyCore {

  /*!
    \class MorletParameters MorletParameters.h
    \brief Brief description of class still missing

    Full description of class still missing
  */

  MorletParameters::MorletParameters()
    : AbstractParameters()
  {
    _fi=1.0;
    _m=1.0;
  }

  double MorletParameters::deltaT() const
  {
    TRACE;
    return 6.0/(2.0*M_PI*_fi)*sqrt(_m);
  }

  double MorletParameters::deltaF() const
  {
    TRACE;
    return _fi/(2.0*6.0*sqrt(_m));
  }

  int MorletParameters::keywordCount(PARAMETERS_KEYWORDCOUNT_ARGS) const
  {
    return 3+AbstractParameters::keywordCount();
  }

  void MorletParameters::collectKeywords(PARAMETERS_COLLECTKEYWORDS_ARGS)
  {
    TRACE;
    int baseIndex=AbstractParameters::keywordCount();
    keywords.add(prefix+"MORLET FI"+suffix, this, baseIndex);
    keywords.add(prefix+"MORLET M"+suffix, this, baseIndex+1);
    keywords.add(prefix+"MORLET W0"+suffix, this, baseIndex+2); // kept to avoid compatibility error
  }

  QString MorletParameters::toString(PARAMETERS_TOSTRING_ARGS_IMPL) const
  {
    TRACE;
    QString log;
    log+=prefix+"MORLET FI"+suffix+"="+QString::number(_fi)+"\n";
    log+=prefix+"MORLET M"+suffix+"="+QString::number(_m)+"\n";
    return log;
  }

  bool MorletParameters::setValue(PARAMETERS_SETVALUE_ARGS)
  {
    TRACE;
    switch(index-AbstractParameters::keywordCount()) {
    case 0:
      _fi=value.toDouble();
      return true;
    case 1:
      _m=value.toDouble();
      return true;
    case 2:
      return true;
    default:
      return false;
    }
    return AbstractParameters::setValue(index, value, unit, keywords);
  }

} // namespace GeopsyCore
