/***************************************************************************
**
**  This file is part of GeopsyCore.
**
**  GeopsyCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  GeopsyCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2013-02-04
**  Copyright: 2013-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "MiniSeedSequence.h"

namespace GeopsyCore {

  /*!
    \class MiniSeedSequence MiniSeedSequence.h
    \brief Brief description of class still missing

    A sequence of Mini Seed records
  */

  const QString MiniSeedSequence::xmlMiniSeedSequenceTag="Sequence";

  /*!
    Description of constructor still missing
  */
  MiniSeedSequence::MiniSeedSequence()
    : XMLClass()
  {
    _count=1;
    _firstPos=0;
    _increment=0;
    _byteLength=0;
  }

  /*!
    Returns true if the record at position \a pos with length \a byteLength
    can be added to this sequence. If so, the record is added to the sequence.
  */
  bool MiniSeedSequence::add(off_t pos, quint32 byteLength)
  {
    if(_byteLength==byteLength) {
      if(_increment==0) {
        if(pos>_firstPos) {
          _increment=pos-_firstPos;
          _count++;
          return true;
        }
      } else if(pos==MiniSeedSequence::pos(_count)) {
        _count++;
        return true;
      }
    }
    return false;
  }

  void MiniSeedSequence::xml_attributes(XML_ATTRIBUTES_ARGS) const
  {
    TRACE;
    Q_UNUSED(context)
    static const QString keys[]={"count", "firstPos", "increment", "byteLength"};
    attributes.add(keys[0], QString::number(_count));
    attributes.add(keys[1], QString::number(_firstPos));
    attributes.add(keys[2], QString::number(_increment));
    attributes.add(keys[3], QString::number(_byteLength));
  }

  bool MiniSeedSequence::xml_setAttributes(XML_SETATTRIBUTES_ARGS)
  {
    TRACE;
    Q_UNUSED(context)
    bool ok=true;
    for(XMLRestoreAttributeIterator it=attributes.begin(); it!= attributes.end(); it++) {
      const StringSection& att=it.key();
      if(att.size()<1) {
        return false;
      }
      switch (att[0].unicode()) {
      case 'c':
        if(att=="count") _count=it.value().toInt(ok); else return false;
        break;
      case 'b':
        if(att=="byteLength") _byteLength=it.value().toInt(ok); else return false;
        break;
      case 'f':
        if(att=="firstPos") _firstPos=it.value().toLongLong(ok); else return false;
        break;
      case 'i':
        if(att=="increment") _increment=it.value().toLongLong(ok); else return false;
        break;
      default:
        return false;
      }
    }
    return ok;
  }

  bool MiniSeedSequence::operator==(const MiniSeedSequence& o) const
  {
    return _count==o._count &&
           _firstPos==o._firstPos &&
           _increment==o._increment &&
           _byteLength==o._byteLength;
  }

} // namespace GeopsyCore
