/***************************************************************************
**
**  This file is part of GeopsyCore.
**
**  GeopsyCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  GeopsyCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2011-01-26
**  Copyright: 2011-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "GuralpSignal.h"

namespace GeopsyCore {

  /*!
    \class GuralpSignal GuralpSignal.h
    \brief De-interlacing tool for reading GCF files or streams

    De-interlacing tool for reading GCF files or streams.
  */

  /*!
    Description of constructor still missing
  */
  GuralpSignal::GuralpSignal(quint64 offset, const GuralpCompressedBlock& b)
  {
    TRACE;
    _firstBlock=b;
    _nSamples=0;
    addRecord(offset, b);
  }

  /*!
    Adds one record. Nota that first block must not be added this way. It is automatically
    add by the contructor.
  */
  void GuralpSignal::addRecord(quint64 offset, const GuralpCompressedBlock& b)
  {
    _nSamples+=b.nSamples();
    _records.add(offset);
    _timeRange.add(b.timeRange(), false);
  }

} // namespace GeopsyCore
