/***************************************************************************
**
**  This file is part of GeopsyCore.
**
**  GeopsyCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  GeopsyCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2011-01-26
**  Copyright: 2011-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef GURALPRECORDS_H
#define GURALPRECORDS_H

#include "MetaData.h"
#include "GeopsyCoreDLLExport.h"

namespace GeopsyCore {

  class GEOPSYCORE_EXPORT GuralpRecords: public MetaData
  {
    METADATA_CLASS(GuralpRecords)
  public:
    GuralpRecords() {}

    virtual bool operator==(const MetaData& o) const {
      return _records==reinterpret_cast<const GuralpRecords&>(o)._records;
    }
    virtual int compare(int, const QString&, const MetaData&) const {return 0;}
    virtual void operator=(const MetaData&) {}

    virtual bool copyAllowed() const {return false;}
    virtual bool isArray(int) const {return false;}

    virtual QString toString(const QString&) const;
    virtual bool fromString(const QString& , QString string);

    void add(quint64 pos) {_records.append(pos);}

    quint64 pos(int index) const {return _records[index];}
    bool isArray(int) {return true;}
    int count(int) const {return _records.count();}
  private:
    VectorList<quint64> _records;
  };

} // namespace GeopsyCore

#endif // GURALPRECORDS_H
