/***************************************************************************
**
**  This file is part of GeopsyCore.
**
**  GeopsyCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  GeopsyCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2018-12-11
**  Copyright: 2018-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef COMPATIBILITYTIMEREFERENCE_H
#define COMPATIBILITYTIMEREFERENCE_H

#include "MetaData.h"
#include "GeopsyCoreDLLExport.h"

namespace GeopsyCore {

  class GEOPSYCORE_EXPORT CompatibilityTimeReference : public MetaData
  {
    METADATA_CLASS(CompatibilityTimeReference)
  public:
    CompatibilityTimeReference() {_t0=0.0;}
    CompatibilityTimeReference(const DateTime& t, double t0) {_timeReference=t; _t0=t0;}
    CompatibilityTimeReference(const DateTime& t) {_timeReference=t; _t0=0.0;}
    CompatibilityTimeReference(double t) {_t0=t;}

    virtual bool operator==(const MetaData& o) const;
    virtual void operator=(const MetaData& o);
    virtual int compare(int, const QString&, const MetaData&) const {return 0;}

    void setTimeReference(const DateTime& t) {_timeReference=t;}
    const DateTime& timeReference() const {return _timeReference;}

    void setT0(double t) {_t0=t;}
    double t0() const {return _t0;}

    DateTime startTime() const;

    virtual QStringList subNames() const;
    virtual QString name(int, const QString&) const;
    virtual QString baseName(int) const;
    virtual QString title(int, const QString&) const;
  private:
    DateTime _timeReference;
    double _t0;
  };

} // namespace GeopsyCore

#endif // COMPATIBILITYTIMEREFERENCE_H

