/***************************************************************************
**
**  This file is part of GeopsyCore.
**
**  GeopsyCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  GeopsyCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2009-10-21
**  Copyright: 2009-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include "AsciiSignalFormatComponent.h"

namespace GeopsyCore {

/*!
  \class AsciiSignalFormatComponent AsciiSignalFormatComponent.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

const QString AsciiSignalFormatComponent::xmlComponentTag="Component";

/*!
  Constructs a basic rule: for all channels, not constant, mandatory, empty pattern, pattern index set to 1, not multiplication factor.
*/
AsciiSignalFormatComponent::AsciiSignalFormatComponent()
{
  _component=Signal::UndefinedComponent;
}

void AsciiSignalFormatComponent::xml_writeProperties(XML_WRITEPROPERTIES_ARGS) const
{
  TRACE;
  Q_UNUSED(context)
  writeProperty(s, "pattern", _pattern);
  writeProperty(s, "component", Signal::standardName(_component));
}

XMLMember AsciiSignalFormatComponent::xml_member(XML_MEMBER_ARGS)
{
  TRACE;
  Q_UNUSED(context)
  Q_UNUSED(attributes)
  if(tag=="pattern" ) return XMLMember(0);
  else if(tag=="component" ) return XMLMember(1);
  else return XMLMember(XMLMember::Unknown);
}

bool AsciiSignalFormatComponent::xml_setProperty(XML_SETPROPERTY_ARGS)
{
  TRACE;
  Q_UNUSED(tag)
  Q_UNUSED(context)
  Q_UNUSED(attributes)
  switch(memberID) {
  case 0: _pattern=content.toStringBuffer(); return true;
  case 1: _component=Signal::standardComponent(content.toStringBuffer()); return true;
  default:
    break;
  }
  return false;
}

} // namespace GeopsyCore
