/***************************************************************************
**
**  This file is part of DinverDCGui.
**
**  DinverDCGui is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  DinverDCGui is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2006-05-18
**  Copyright: 2006-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef DCMODELVIEWER_H
#define DCMODELVIEWER_H

#include <DinverCore.h>
#include <DinverDCCore.h>
#include <QGpCoreTools.h>
#include <SciFigs.h>

#include "DinverDCGuiDLLExport.h"

namespace DinverDCGui {

class DINVERDCGUI_EXPORT DCModelViewer : public QWidget
{
  Q_OBJECT
public:
  DCModelViewer(QWidget * parent=nullptr);
  ~DCModelViewer();

  void initGraphs(int nGraphs);
  virtual void setMode(const Mode& ) {}
  virtual void setModeIndex(int) {}
  virtual void setFrequencyAxis(bool) {}
  virtual void setTarget(const TargetList * tl);
  void setLayerComments(const QStringList& reportList);
  void setColorMap(const ColorMap& m);
  void selectModels(QString reportFileName, double maxMisfit, int minIndex, int maxIndex);
  void selectModels(DCModelViewer * w, const VectorList<int> * indexes);
  void rejectModels(DCModelViewer * w, const VectorList<int> * indexes);
  void loadModels();
  int modelCount() const {return _models.count();}

  GraphicSheet * sheet() {return &_sheet;}
  void exportPlot(const ExportOptions& o);
public slots:
  void setLimits();
  void setDefaultPalette();
  void showSelectedModels(int id, const VectorList<int>* indexes);
protected slots:
  virtual void showTarget(bool isVisible);
protected:
  QMenu * addMenu(QString title);
  TextEdit * addText(int ig, QString text);
  virtual AbstractLine * targetReferenceLine() const=0;

  GraphicSheet _sheet;
  ColorMapWidget * _colorMap;
  QVBoxLayout* _childLayout;
#ifndef Q_OS_DARWIN
  QMenuBar * _menuBar;
#endif

  QList<DCModelInfo *> _models;

  int _nGraphs;
  AxisWindow ** _graphs;
  XYValueLines ** _curveLayers;
  LineLayer ** _targetLayers;
  int ** _pCounts;
  double * _misfits;

  void addActions();
  virtual void setTitles(int i)=0;
  virtual bool hasCurves(DCReportBlock& dcBlock, int version)=0;
  virtual void setSampleCount(DCModelInfo * info, DCReportBlock& dcBlock)=0;
  virtual void report2plot(DCReportBlock& dcBlock, Point2D ** points, const DCModelInfo& info)=0;
  virtual void setLimits(int i, const Rect& r)=0;
  virtual void setGlobalLimits(const Rect&) {}
};

} // namespace DinverDCGui

#endif // DCMODELVIEWER_H
