/***************************************************************************
**
**  This file is part of DinverDCCore.
**
**  DinverDCCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  DinverDCCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2019-01-17
**  Copyright: 2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef POWERLAWPROFILE_H
#define POWERLAWPROFILE_H

#include "GradientProfile.h"
#include "DinverDCCoreDLLExport.h"

namespace DinverDCCore {

  class DINVERDCCORE_EXPORT PowerLawProfile: public GradientProfile
  {
  public:
    PowerLawProfile(int n) : GradientProfile(n) {_dv=0.0;}
    PowerLawProfile(const PowerLawProfile& o) : GradientProfile(o) {_dv=o._dv;}

    virtual GradientProfile * clone() const {return new PowerLawProfile(*this);}

    virtual bool setGradient(double alpha);

    virtual bool setBottomValue(double v);
    double bottomValue() const;

    virtual void setDepths(int topIndex, Profile& p);
    virtual void setValues(int topIndex, Profile& p);

    virtual void setMinimumTopValue(double value, double depth);
    virtual void setMaximumTopValue(double value, double depth);
    virtual void setMinimumGradient(double, double) {}
    virtual void setMaximumGradient(double, double) {}

    //void fineCheckMinimum(double value, double depth);
    //void fineCheckMaximum(double value, double depth);
  private:
    //void printDebug() const;
    void setValueStep();
    inline double valueAt(int index) const;
    double subLayerBottomDepth(int index, double subLayerTopDepth) const;
    int minimumIndexOf(double depth) const;
    int maximumIndexOf(double depth) const;
    //void scanGradient(double value);

    double _dv;
  };

  inline double PowerLawProfile::valueAt(int index) const
  {
    return 1.0+_dv*static_cast<double>(1+2*index);
  }

} // namespace DinverDCCore

#endif // POWERLAWPROFILE_H

