/***************************************************************************
**
**  This file is part of DinverDCCore.
**
**  DinverDCCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  DinverDCCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2007-08-09
**  Copyright: 2007-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef GROUNDPARAMETER_H
#define GROUNDPARAMETER_H

#include <DinverCore.h>

#include "DinverDCCoreDLLExport.h"

namespace DinverDCCore {

class ParamLayer;
class ParamGroundModel;

class DINVERDCCORE_EXPORT GroundParameter : public Parameter
{
public:
  enum Type {ValueTop, ValueGradient, ValueBottom, Depth, Thickness};

  GroundParameter(const ParamGroundModel * groundModel, const ParamLayer * layer,
                  Type type, double min, double max);

  const ParamGroundModel * groundModel() const {return _groundModel;}
  void addLayer(const ParamLayer * layer) {_layers << layer;}
  const ParamLayer * layer(int index) const {return _layers.at(index);}
  int count() const {return _layers.count();}
  Type type() const {return _type;}
private:
  const ParamGroundModel * _groundModel;
  QList<const ParamLayer *> _layers;
  Type _type;
};

} // namespace DinverDCCore

#endif // GROUNDPARAMETER_H
