/***************************************************************************
**
**  This file is part of DinverDCCore.
**
**  DinverDCCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  DinverDCCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2009-07-27
**  Copyright: 2009-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include "EllipticityPeakTarget.h"

namespace DinverDCCore {

  /*!
    \class EllipticityPeakTarget EllipticityPeakTarget.h
    \brief Brief description of class still missing

    Full description of class still missing
  */

  const QString EllipticityPeakTarget::xmlEllipticityPeakTargetTag="EllipticityPeakTarget";

  /*!
    Description of constructor still missing
  */
  EllipticityPeakTarget::EllipticityPeakTarget()
      : Target()
  {
    TRACE;
    _value.setWeight(1.0);
    _value.setValid(false);
    _minimumAmplitude=0.0;
  }

  /*!
    Description of constructor still missing
  */
  EllipticityPeakTarget::EllipticityPeakTarget(const EllipticityPeakTarget& o)
      : Target(o)
  {
    TRACE;
    _value=o._value;
    _minimumAmplitude=o._minimumAmplitude;
  }

  void EllipticityPeakTarget::xml_writeProperties(XML_WRITEPROPERTIES_ARGS) const
  {
    TRACE;
    Q_UNUSED(context)
    writeProperty(s, "minimumAmplitude", _minimumAmplitude);
  }

  void EllipticityPeakTarget::xml_writeChildren(XML_WRITECHILDREN_ARGS) const
  {
    TRACE;
    _value.xml_save(s, context);
  }

  XMLMember EllipticityPeakTarget::xml_member(XML_MEMBER_ARGS)
  {
    TRACE;
    Q_UNUSED(context)
    if(tag=="RealStatisticalValue" ||
       tag=="StatValue") { // Kept for compatibility <=201005
      return XMLMember(&_value);
    } else if(tag=="minimumAmplitude") {
      return XMLMember(0);
    } else return Target::xml_member(tag, attributes, context)+1;
  }

  bool EllipticityPeakTarget::xml_setProperty(XML_SETPROPERTY_ARGS)
  {
    TRACE;
    Q_UNUSED(tag)
    Q_UNUSED(attributes)
    Q_UNUSED(context)
    bool ok=true;
    switch(memberID) {
    case 0:
      _minimumAmplitude=content.toDouble(ok);
      return ok;
    default:
      return Target::xml_setProperty(memberID-1, tag, attributes, content, context);
    }
  }
} // namespace DinverDCCore
