/***************************************************************************
**
**  This file is part of DinverCore.
**
**  DinverCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  DinverCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2009-06-08
**  Copyright: 2009-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include "XMLDinver.h"
#include "DinverInterface.h"
#include "DinverCoreEngine.h"

namespace DinverCore {

/*!
  \class XMLDinver XMLDinver.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

const QString XMLDinver::xmlDinverTag="Dinver";

/*!
  Description of constructor still missing
*/
XMLDinver::XMLDinver(DinverInterface * plugin)
{
  TRACE;
  _plugin=plugin;
}

/*!
  Description of destructor still missing
*/
XMLDinver::~XMLDinver()
{
  TRACE;
}

void XMLDinver::xml_writeProperties(XML_WRITEPROPERTIES_ARGS) const
{
  TRACE;
  Q_UNUSED(context)
  writeProperty(s, "pluginTag", _plugin->tag());
  writeProperty(s, "pluginTitle", _plugin->title());
}

void XMLDinver::xml_writeChildren(XML_WRITECHILDREN_ARGS) const
{
  TRACE;
  _plugin->xml_writeChildren(s, context);
}

XMLMember XMLDinver::xml_member(XML_MEMBER_ARGS)
{
  if(tag=="InversionThread") return XMLMember(XMLMember::Skip);
  else if(tag=="pluginTag") return XMLMember(0);
  else if(tag=="pluginTitle") return XMLMember(1);
  else if(tag=="newRunDirectory") return XMLMember(2); // Kept for compatibility
  else {
    return _plugin->xml_member(tag, attributes, context)+3;
  }
}

bool XMLDinver::xml_setProperty(XML_SETPROPERTY_ARGS)
{
  TRACE;
  Q_UNUSED(tag)
  Q_UNUSED(attributes)
  Q_UNUSED(context)
  switch(memberID) {
  case 0:
    if(content!=_plugin->tag()) {
      Message::critical(MSG_ID,tr("Loading environment"),
                        tr("This environment was not saved with the current Dinver"
                           "plugin (%1).\nRestart Dinver with the appropriate module or select another environment file.")
                           .arg(_plugin->tag()),
                        Message::cancel());
      return false;
    }
    return true;
  case 1: // silently ignored
    return true;
  case 2: // Kept for compatibility
    return true;
  default:
    return false;
  }
}

void XMLDinver::xml_polishChild(XML_POLISHCHILD_ARGS)
{
  TRACE;
  _plugin->xml_polishChild(child, context);
}

} // namespace DinverCore
